/*******************************************************************************
 * Copyright (c) 2000, 2019 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Microsoft Corporation - copied to jdt.core.manipulation
 *******************************************************************************/
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.jdt.core.search.SearchMatch;

/**
 * Interface for search requestors used in conjunction with {@link org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2}.
 *
 * @since 3.1
 */
public interface IRefactoringSearchRequestor {

	/**
	 * Can the search match be accepted?
	 *
	 * @param match the search match to test
	 * @return The accepted match, or <code>null</code> if not accepted
	 */
	SearchMatch acceptSearchMatch(SearchMatch match);
}
